#!/usr/bin/perl
#
# BlueLava v0.4.3
# (c) 2001-2004  Ian Wilkinson (ian@sgtwilko.f9.co.uk)
# (c) 1999  Bruce Locke  (blocke@shivan.org)
#
# Released under the GPL v2... see COPYING for details
# This software comes without any warranty...
#

#
# htmlgen.pl contains 99% of the html generating code in bluelava
#

# stuff that must be set up after reading configuration file


sub htmlgen_init
{

$bluelava_version =
"<p>
<a href=\"http://www.sgtwilko.f9.co.uk/bluelava\">BlueLava</a> v0.4.3 -
&copy; 2001-2004  Ian Wilkinson 
(<a href=\"mailto:ian\@sgtwilko.f9.co.uk\">ian\@sgtwilko.f9.co.uk</a>)</p>";

$bluelava_url = $config_settings{"bluelava_baseurl"};

$html_include_path = $config_settings{"bluelava_html"};

$default_text_color = $config_settings{"default_text_color"};
$default_text_dimmed = $config_settings{"default_text_dimmed"};


if ( $config_settings{"table_use_gradient"} eq "yes")
{
	$row_color = hex($config_settings{"table_gradient_start"});
	$row_colorchange = hex($config_settings{"table_gradient_colorchange"});

	if ($config_settings{"table_gradient_colorop"} eq "subtract")
	{
		$row_colorchange = -$row_colorchange;
	}
}
else
{
	$row_color = $config_settings{"default_row_color"};
}

}

# cat_file: equivalent to  cat filename  in unix

sub cat_file
{

#print "$filename";
 
local ($filename) = @_;
my ($line);

open (CATFILE, $filename);

while (defined ($line = <CATFILE>))
 {
          print "$line";
 }
  
close(CATFILE);
}
 

sub html_bluelava_redirect
{
local ($params) = @_;

print ("Location: $bluelava_url/bluelava.cgi","$params\n");
print "Connection: close\n";
print "Content-Type: text/html\n\n";

print <<END_OF_HTML
<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
<HTML><HEAD>
<TITLE>302 Found</TITLE>
</HEAD><BODY>
<H1>Found</H1>

END_OF_HTML
;

print ("The document has moved <A HREF=\"$bluelava_url/bluelava.cgi", "$params\">here</A>.<P>\n");
print "</BODY></HTML>\n";
}


#
#  *** GENERATION OF STATUS SCREEN ***
#

sub html_header
{
	cat_file ("$html_include_path/header.html");
}

sub html_footer
{
	cat_file ("$html_include_path/footer.html");
}




sub html_table_header
{

local ($name) = @_;


local ($header_color_fg) = $config_settings{"header_color_fg"};
local ($header_color_bg) = $config_settings{"header_color_bg"};


print <<END_OF_HTML

<tr>
<td bgcolor="#$header_color_bg" colspan=6>
<center>
<font color="#$header_color_fg">
END_OF_HTML
;

print "<b>$name</b>";

print <<END_OF_HTML

</font>
</center>
</td>
</tr>

END_OF_HTML
;

}

sub html_table_device
{

local ($device_name, $device_id, $device_type) = @_;

if ( $config_settings{"table_use_gradient"} eq "yes")
{
	$row_color = $row_color + $row_colorchange;
}

$row_color_hex = sprintf ("#%06x", $row_color);

print "<tr> <td bgcolor=\"$row_color_hex\">\n";
print "<font size=\"-1\" color=\"#$default_text_color\">$device_name [$device_id]</font>\n";
print "</td><td bgcolor=\"$row_color_hex\"><font size=\"-1\" color=\"#$default_text_color\">";

if ($device_type eq "lamp")
{
	print "Lamp";
} 
elsif ($device_type eq "appliance")
{
	print "Appliance";
}
else
{
	print "<i>Unknown</i>";
}

print "</font></td>";

print "<td width=10% bgcolor=\"$row_color_hex\"><font size=\"-1\" color=\"#$default_text_color\">
<a href=\"$bluelava_url/bluelava.cgi?action=on&device=$device_id\">On</a></font></td>  ";

print "<td width=10% bgcolor=\"$row_color_hex\"><font size=\"-1\" color=\"#$$default_text_color\">
<a href=\"$bluelava_url/bluelava.cgi?action=off&device=$device_id\">Off</a></font></td> ";

if ($device_type eq "lamp")
{
	print "<td width=10% bgcolor=\"$row_color_hex\"><font size=\"-1\" color=\"#$default_text_color\"><a href=\"$bluelava_url/bluelava.cgi?action=bright&device=$device_id\">Brighten</a></font></td>";
	print "<td width=10% bgcolor=\"$row_color_hex\"><font size=\"-1\" color=\"#$default_text_color\"><a href=\"$bluelava_url/bluelava.cgi?action=dim&device=$device_id\">Dim</a></font></td> ";
}
else
{
	print "<td width=10% bgcolor=\"$row_color_hex\"><font size=\"-1\" color=\"#$default_text_dimmed\">Brighten</font></td>";
	print "<td width=10% bgcolor=\"$row_color_hex\"><font size=\"-1\" color=\"#$default_text_dimmed\">Dim</font></td>";
}

print "</tr>";

}

sub html_table_labels
{

$label_device_fg	= $config_settings{"label_device_fg"};
$label_device_bg	= $config_settings{"label_device_bg"};

$label_type_fg		= $config_settings{"label_type_fg"};
$label_type_bg		= $config_settings{"label_type_bg"};

$label_actions_fg	= $config_settings{"label_actions_fg"};
$label_actions_bg	= $config_settings{"label_actions_bg"};


print "<tr>";
print "<td bgcolor=\"#$label_device_bg\" width=50% colspan=1>
<font color=\"#$label_device_fg\" size=\"-1\"> 
<b>
Device
</b>  
</font>
</td>";

print "
<td bgcolor=\"#$label_type_bg\" width=10% colspan=1>
<font color=\"#$label_type_fg\" size=\"-1\">
<b>
Type
</b>
</font>
</td> ";

print " 
<td bgcolor=\"#$label_actions_bg\" width=40% colspan=4>
<font color=\"#$label_actions_fg\" size=\"-1\">
<b>
Actions
</b>                  
</font>
</td>  </tr> ";

}

sub html_link_roomfunc
{
local ($linktext, $action, $room) = @_;

print "<td colspan=1 bgcolor=\"$row_color_hex\">";
print "<font size=\"-1\">";
print "<a href=\"$bluelava_url/bluelava.cgi?action=$action&room=$room\">$linktext</a>";
print "</td>";
}

sub html_table_room_options
{

local ($room_name) = @_; 
local ($bluelava_url) = $config_settings{"bluelava_baseurl"};

print "<tr>";
print "<td colspan=2 bgcolor=\"$row_color_hex\">";
print "<br></td>";

html_link_roomfunc("Lights On", "lon", $room_name);
html_link_roomfunc("Lights Off", "loff", $room_name);

html_link_roomfunc("All On", "aon", $room_name);
html_link_roomfunc("All Off", "aoff", $room_name);

print "</td></tr>";


}

sub html_table_about_action
{

local ($message) = @_;


local ($status_color_fg) = $config_settings{"status_color_fg"};
local ($status_color_bg) = $config_settings{"status_color_bg"};

if ($message ne "")
{
print "<tr><td colspan=6 bgcolor=\"#$status_color_bg\" align=left>";
print "<font size=\"-1\" color=\"#$status_color_fg\"><b>Status:</b> $message</font>";
print "</td></tr>";
}

print "<tr><td colspan=6 bgcolor=\"#$status_color_bg\" align=left>";
print "<font size=\"-1\" color=\"#$status_color_fg\">$bluelava_version</font>";
print "</td></tr>"



}

#Show admin bar if allowed.
sub html_table_admin
{
	if (CGI->remote_addr() eq "127.0.0.1") {
		local($bluelava_url)=$config_settings{"bluelava_baseurl"};
		local($selectedBG)=$config_settings{"header_color_bg"};
		local($selectedFG)=$config_settings{"header_color_fg"};
		local($myBG, $myFG, $notSel1BG, $notSel1FG, $notSel2BG, $notSel2FG);
		$notSel1BG=$config_settings{label_device_bg};
		$notSel1FG=$config_settings{label_device_fg};
		$notSel2BG=$config_settings{label_type_bg};
		$notSel2FG=$config_settings{label_type_fg};
		if (! (defined ($admin))) {
			$myBG=$selectedBG;
			$myFG=$selectedFG;
		} else {
			$myBG=$notSel1BG;
			$myFG=$notSel1FG;
			$notSel1BG=$notSel2BG;
			$notSel1FG=$notSel2FG;
		}
		print "<table width=80% align=center valign=top border=0 cellspacing=0 border=0><tr><td align=left bgcolor=\"#$myBG\"><a href=\"$bluelava_url/bluelava.cgi\"><font color=\"#$myFG\">BlueLava Rooms</font></a></td>";
#		$remote_host=CGI->http('Accept-language');
		if ($admin eq "1"){
			$myBG=$selectedBG;
			$myFG=$selectedFG;
		} else {
			$myBG=$notSel1BG;
			$myFG=$notSel1FG;
		}
		print "<td align=center bgcolor=\"#$myBG\"><a href=\"$bluelava_url/bluelava.cgi?admin=1\"><font color=\"#$myFG\">Room Setup</font></a></td>";
		if ($admin eq "2"){
			$myBG=$selectedBG;
			$myFG=$selectedFG;
		} else {
			$myBG=$notSel2BG;
			$myFG=$notSel2FG;
		}
		print "<td align=right bgcolor=\"#$myBG\"><a href=\"$bluelava_url/bluelava.cgi?admin=2\"><font color=\"#$myFG\">BlueLava Settings</font></a></td>";
		print "</td></tr></table>";
	}
}

# basic table start and end functions

sub html_table_start
{

print <<END_OF_HTML
<table width=80% align=center valign=top border=0 cellspacing=2
cellpadding=0 border=0>
END_OF_HTML
;

}

sub html_table_end
{
print "</table>";
}

# html_status_table: generates the nice html table

sub html_status_table
{

local ($message) = @_;
local ($deviceptr, @devicelist, %devicehash, $device);

foreach $room (sort keys %config_rooms)
{

	html_table_header($room);
	html_table_labels();

	$deviceptr = $config_rooms{$room};
	@devicelist = @$deviceptr;

	foreach $device (@devicelist)
	{
		%devicehash = %$device;

		html_table_device($devicehash{"name"}, $devicehash{"id"}, $devicehash{"type"});
	}

	html_table_room_options($room);

}

	html_table_about_action($message);
}


#
# Generates the page!
#

sub generate_status_page
{
local ($message) = @_;

print "Content-type: text/html \n\n";

html_header();
html_table_admin();
html_table_start();

html_status_table($message);

html_table_end();
html_footer();      
}


#
#  The following generates the "dialog boxes"
#

sub html_notice
{

local ($notice_topic, $notice_message, $textcolor, $bgcolor) = @_;

html_table_start();

print <<END_OF_HTML

<tr>
<td bgcolor="$bgcolor" align=left valign=top>
<font color="$textcolor">
<b>$notice_topic</b>
</font>
</td>  
</tr>  

<tr>
<td bgcolor="#cccccc" align=left valign=top>
$notice_message
</td>
</tr>

<tr>
<td bgcolor=\"#$config_settings{"status_color_bg"}\">
<font size="-1" color=\"$config_settings{"status_color_fg"}\">
$bluelava_version
</font>
</td>  
</tr>  

END_OF_HTML
;

html_table_end();

}

sub html_errormsg
{

local ($notice_topic, $notice_message) = @_;

print "Content-type: text/html \n\n";

html_header();
html_notice ($notice_topic, $notice_message, "#FFFFFF", "#FF0000");
html_footer();
}



# end of html.pl
1;
